*************************************
*Run the Create Variables - HILDA.do file first 
***************************************

******************************************************
*regression: Table C2: Household-Level Liquidity Buffers
*******************************************************
*sample:indebted owners
*OLS without controls 
reg liqratio hprice_to_dinc  if mortgagor==1, cl(xwaveid)
outreg2 using hprice, word dec(2)

*OLS with controls 
reg liqratio hprice_to_dinc age agesq ln_dinc hhsize *_pastyear   i.year if mortgagor==1, cl(xwaveid)
outreg2 using hprice, word append dec(2) drop(i.year) noomitted 

*FE with controls 
destring xwaveid, replace
xtset xwaveid year
xtreg liqratio hprice_to_dinc age agesq  ln_dinc hhsize *_pastyear  i.year if mortgagor==1, cl(xwaveid) fe
outreg2 using hprice, word append dec(2)  drop(i.year) noomitted 


*sample: all households (housing price of renters = reported housing prices of owners in the same SA4 area)
*OLS without controls 
reg liqratio hprice_to_dinc  , cl(xwaveid)
outreg2 using hprice, word append dec(2)   noomitted 

*OLS with controls 
reg liqratio hprice_to_dinc age agesq ln_dinc hhsize *_pastyear  i.year , cl(xwaveid)
outreg2 using hprice, word append dec(2) drop(i.year) noomitted 

*FE with controls
xtreg liqratio hprice_to_dinc age agesq  ln_dinc hhsize *_pastyear  i.year , cl(xwaveid) fe
outreg2 using hprice, word append dec(2) drop(i.year)  noomitted 


***********************************
*Event study graphs
***********************************
*Figure 14: Household Liqui assets
*Buffers by years since first purchase 
*3-panel 

*piecewise estimates 
g yrs_since1=yrs_since
replace yrs_since1=0 if yrs_since>=0

g yrs_since2=yrs_since
replace yrs_since2=0 if yrs_since<0

g int1=1
replace int1=0 if yrs_since>=0 

g int2=1 
replace int2=0 if yrs_since<0 

reg liqratio int1 int2 yrs_since1 yrs_since2 if yrs_since>=-4 & yrs_since<=20 & liqratio<100, hascons 
predict liqratio_pw ,xb 

*data for top-panel (all area)
tabstat liqratio liqratio_pw if yrs_since>=-4 & yrs_since<=20 & liqratio<100, by(yrs_since) 
 
*Buffers by years since first purchase, split by households living in Sydney/Melbourne and other region 
reg  liqratio int1 int2 yrs_since1 yrs_since2 if expensive == 1 & yrs_since>=-4 & yrs_since<=20 & liqratio<100
predict pliqratio_capcity, xb

reg  liqratio int1 int2 yrs_since1 yrs_since2 if expensive == 0 & yrs_since>=-4 & yrs_since<=20 & liqratio<100
predict pliqratio_regional, xb

*data for middle-panel and bottom panel (expensive and regional area)
tabstat liqratio_capacity pliqratio_capcity liqratio_regional pliqratio_regional if yrs_since>=-4 & yrs_since<=20 & liqratio<100, by(yrs_since) 


*Buffers by years of paying off mortgages 

tabstat liqratio if liqratio<100 & yrs_since_paidoff<=10 & yrs_since_paidoff>=-10 , by(yrs_since_paidoff) s(median mean)

